﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Message.master" AutoEventWireup="true" CodeBehind="Messages.aspx.cs" Inherits="GUI.Pages.Messages" %>
<%@ Register Src="~/Controls/FolderNavigationControl.ascx" TagName="FolderNavigationControl" TagPrefix="uc" %>
<asp:Content ID="Content3" ContentPlaceHolderID="LeftNavigationPlaceHolder" runat="server">
    <uc:FolderNavigationControl runat="server" ID="FolderNavigationControl" />
    <%--<script src="../repository/scripts/mail.js"></script>--%>
</asp:Content>

<asp:Content ID="Content4" ContentPlaceHolderID="FormPlaceHolder" runat="server">

    <div class="row">
        <div class="col-md-12">
            <div class="btn-group btn-group-solid">
                <asp:Button OnClick="btnNew_Click" runat="server" ID="btnNew" CssClass="btn btn-default" CausesValidation="false" Text="<%$ Resources:ProjectManagementUI, Common_New %>"/>
                <asp:Button OnClick="btnReply_Click" runat="server" ID="btnReply" CssClass="btn btn-default" CausesValidation="false" Text="<%$ Resources:ProjectManagementUI, Common_MessageReply %>"/>
                <asp:Button OnClick="btnReplyAll_Click" runat="server" ID="btnReplyAll" CssClass="btn btn-default" CausesValidation="false" Text="<%$ Resources:ProjectManagementUI, Common_MessageReplyAll %>"/>
                <asp:Button OnClick="btnForward_Click" runat="server" ID="btnForward" CssClass="btn btn-default" CausesValidation="false" Text="<%$ Resources:ProjectManagementUI, Common_MessageForward %>"/>
                <asp:Button OnClick="btnDelete_Click" runat="server" ID="btnDelete" CssClass="btn btn-default" CausesValidation="false" Text="<%$ Resources:ProjectManagementUI, Common_Delete %>"/>
                <asp:Button OnClick="btnMarkAllRead_Click" runat="server" ID="btnMarkAllRead" CssClass="btn btn-default" CausesValidation="false" Text="<%$ Resources:ProjectManagementUI, Common_MessageMarkAllAsRead %>"/>
            </div>
        </div>
    </div>
    
    <hr>
  
    <div class="portlet-body form">
        <telerik:RadClientDataSource runat="server" ID="rcdsMessages">
        </telerik:RadClientDataSource>
       <div class="row">
            <div class="col-md-12">
                                <div class="form-group">
                                    <div class="table-wrapper">
                              
            <telerik:RadGrid runat="server" ID="grdList" CssClass="kendo-table" GridLines="None" AutoGenerateColumns="false" Height="100%"
                EnableViewState="false" AllowPaging="true" AllowMultiRowSelection="false" Skin="Bootstrap" AllowSorting="true" PageSize="5" ShowGroupPanel="false" AllowFilteringByColumn="false" 
                OnNeedDataSource="grdList_OnNeedDataSource" OnItemDataBound="grdList_OnItemDataBound">
             <ClientSettings AllowDragToGroup="true" EnableRowHoverStyle="true" AllowKeyboardNavigation="false">
                    <Selecting AllowRowSelect="true" />
                  <ClientEvents OnRowSelected="RowSelected"></ClientEvents>

                    </ClientSettings>
                <MasterTableView ShowHeadersWhenNoRecords="true"  ShowFooter="False" AutoGenerateColumns="False" DataKeyNames="Id,FromUser,Title,DateSendReceived,Body,CreatedBy,ToUserName,ToUserNameIds,MessageUserId,IsRead,Folder"  ClientDataKeyNames="Id,FromUser,Title,DateSendReceived,Body,CreatedBy,ToUserName,ToUserNameIds,MessageUserId,IsRead,Folder" CssClass="table table-striped table-hover">
                  
                    <Columns>
                        <telerik:GridClientSelectColumn  UniqueName="Select" HeaderStyle-Width="35px"/>
                        <telerik:GridBoundColumn DataField="FromUser" UniqueName="From" HeaderText="<%$ Resources:ProjectManagementUI, Common_From %>" HeaderStyle-Width="200px" />
                        <telerik:GridBoundColumn DataField="Title" UniqueName="Subject" HeaderText="<%$ Resources:ProjectManagementUI, Common_SubjectMessage %>" ItemStyle-CssClass="subject" />
                        <telerik:GridBoundColumn DataField="DateSendReceived" UniqueName="Received" HeaderText="<%$ Resources:ProjectManagementUI, Common_Date %>" DataFormatString="{0:d/M/yyyy HH:mm:ss}" HeaderStyle-Width="200px" />
                        <telerik:GridBoundColumn DataField="FolderName" UniqueName="FolderName" HeaderText="<%$ Resources:ProjectManagementUI, Common_FolderMessage %>" DataType="System.String" />
                        <telerik:GridTemplateColumn HeaderStyle-Width="35px" HeaderText="" UniqueName="Replayed" >
								                        <ItemTemplate>
									                         <i class="fa fa-mail-<%# (Eval("IsReplayed").ToString() == "True") ? "reply font-kendo-blue" : "reply font-kendo-gray" %>"></i>  
								                        </ItemTemplate>
								                        <ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
							                        </telerik:GridTemplateColumn>
                        <telerik:GridTemplateColumn  HeaderStyle-Width="35px" HeaderText="" UniqueName="Forwarded" >
								                       <ItemTemplate>
									                         <i class="fa fa-mail-<%# (Eval("IsForwarded").ToString() == "True") ? "forward font-kendo-blue" : "forward font-kendo-gray" %>"></i> 				                        
								                        <ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
                                                           </ItemTemplate>
							                        </telerik:GridTemplateColumn>
                        <telerik:GridTemplateColumn  HeaderStyle-Width="35px" HeaderText="" UniqueName="Deleted" >
								                       <ItemTemplate>
									                         <i class="fa fa-<%# (Eval("IsDeleted").ToString() == "True") ? "trash font-kendo-blue" : "trash font-kendo-gray" %>"></i> 				                        
								                        <ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
                                                           </ItemTemplate>
							                        </telerik:GridTemplateColumn>
                                              
                      </Columns>
                </MasterTableView>
            </telerik:RadGrid>
        </div>
  </div>
                  </div>

        <input type="hidden" id="clickedRowMessageId" />
 
        <telerik:RadContextMenu runat="server" ID="messagesContextMenu" ClientIDMode="Static" style="background:white">
            <Items>
                <telerik:RadMenuItem Text="Reply" NavigateUrl="MessageNew.aspx?action=reply" />
                <telerik:RadMenuItem Text="Reply All" NavigateUrl="MessageNew.aspx?action=replyall" />
                <telerik:RadMenuItem Text="Forward" NavigateUrl="MessageNew.aspx?action=forward" />
                <telerik:RadMenuItem IsSeparator="true" />
                <telerik:RadMenuItem Text="Mark as unread" />
                <telerik:RadMenuItem Text="Mark as read" />
                <telerik:RadMenuItem Text="Delete" />
                <telerik:RadMenuItem IsSeparator="true" />
              
            </Items>
        </telerik:RadContextMenu>
      
       </div>
      
    <div class="row">
        <div class="col-md-12">
            <div class="form-group" style="background: #fff; padding: 15px 15px;">
                <asp:Panel runat="server" ID="pnlMessage" CssClass="mailDetails" EnableViewState="false"
                    ClientIDMode="Static" style="display:none;">
    
                    <div class="header">
                        <div>
                            <span style="display:block;color:#000;font-weight:bold;margin:10px 0 0 0;">
                                <asp:Literal ID="Literal4Nested" runat="server"
                                    Text="<%$ Resources:ProjectManagementUI, Common_SubjectMessage %>" />
                                <span id="subject" style="display:block;color:#000;font-weight:normal;margin:10px 0 0 0;">
    
                                </span>
                            </span>
                        </div>
                        <div>
                            <span style="display:block;color:#000;font-weight:bold;margin:10px 0 0 0;">
                                <asp:Literal ID="Literal1" runat="server"
                                    Text="<%$ Resources:ProjectManagementUI, Common_FromMessage %>" />
                                <span id="from" style="display:block;color:#000;font-weight:normal;margin:10px 0 0 0;">
    
                                </span>
                            </span>
                        </div>
    
                        <div>
                            <span style="display:block;color:#000;font-weight:bold;margin:10px 0 0 0;">
                                <asp:Literal ID="Literal2" runat="server"
                                    Text="<%$ Resources:ProjectManagementUI, Common_Date %>" />
                                <span id="recieved" style="display:block;color:#000;font-weight:normal;margin:10px 0 0 0;">
    
                                </span>
                            </span>
                        </div>
    
                        <span style="display:block;color:#000;font-weight:bold;margin:10px 0 0 0;">
                            <asp:Literal ID="Literal3" runat="server"
                                Text="<%$ Resources:ProjectManagementUI, Common_Message %>" />
                        </span>
                        <div id="body" style="display:block;color:#000;font-weight:normal;margin:10px 0 0 0;">
    
                        </div>
    
                    </div>
                </asp:Panel>
            </div>
        </div>
    </div>
        </div>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="ScriptPlacerholder" runat="server">
    <telerik:RadCodeBlock runat="server">
			<script type="text/javascript">
			    function RowSelected(sender,args) {

			         var id = args.getDataKeyValue("Id");
			        //alert(id);
			         var x = document.getElementById('pnlMessage');
			         x.style.display = 'block';
			        $("#from").text(args.getDataKeyValue("FromUser"));
			        $("#subject").text(args.getDataKeyValue("Title"));
			        $("#recieved").text(args.getDataKeyValue("DateSendReceived"));
			        $("#body").html(args.getDataKeyValue("Body")).text();

			        var messageUserId = args.getDataKeyValue("MessageUserId");
			        PageMethods.MarkAsRead(messageUserId, success, error);

			       <%-- RefreshGrid("<%= grdList.ClientID %>");--%>

                    }
			    function success(data) {
			        console.log(data);
			      }
			    function error(data) {
			        console.log(data);
			    }
	    </script>
	</telerik:RadCodeBlock>
                                        
</asp:Content>
